<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CampaignScheduledItem extends Model 
{

    protected $table = 'campaign_scheduled_item';
    public $timestamps = true;
    protected $fillable = array('campaign_id', 'component_playlist_id', 'context', 'ordering', 'mode', 'date_from', 'date_to', 'time_from', 'time_to', 'dow', 'period', 'size', 'priority', 'shuffle', 'immediate', 'music_spot_offset');

    public function campaign()
    {
        return $this->belongsTo('App\Models\Campaign');
    }

    public function componentPlaylist()
    {
        return $this->belongsTo('App\Models\ComponentPlaylist');
    }

}